def create_nums(n):
    """
    Given non-negative in n, create and return a "nums"
    dict that has a key for every number in the range 0..n-1,
    and its value is the string form of that number,
    so n=3 returns {0: '0', 1: '1', 2: '2'}

    >>> create_nums(3)
    {0: '0', 1: '1', 2: '2'}
    >>> create_nums(4)
    {0: '0', 1: '1', 2: '2', 3: '3'}
    >>> create_nums(2)
    {0: '0', 1: '1'}
    >>> create_nums(1)
    {0: '0'}
    >>> create_nums(0)
    {}
    """
    nums = {}  # create empty dict
    for i in range(n):  # from 0 - (n -1)
        nums[i] = str(i)  # key is integer, value is string of num
    return nums


def year_count(dates):
    """
    Given a list of date strings, all of which
    have the form m/d/y form like '3/25/2020'.
    Build a counts dict, where each key is an
    int year, and its value is the number of
    dates in the list with that year.
    >>> year_count(['1/2/2019', '11/12/2019', '11/4/2020', '1/6/2021'])
    {2019: 2, 2020: 1, 2021: 1}
    >>> year_count(['1/2/2019', '11/12/2019', '12/4/2019', '1/6/2019'])
    {2019: 4}
    >>> year_count(['1/2/2019', '11/12/2020', '12/4/2021', '1/6/2022'])
    {2019: 1, 2020: 1, 2021: 1, 2022: 1}
    >>> year_count(['1/1/2000'])
    {2000: 1}
    >>> year_count([])
    {}
    """
    counts = {}
    for date in dates:
        # find where slashes are
        slash1 = date.find('/')
        slash2 = date.find('/', slash1 + 1)
        # extract int year, build counts
        year = int(date[slash2 + 1:])
        if year not in counts:
            counts[year] = 0
        counts[year] += 1
    return counts
    # Cute alternative:
    # could use parts = date.split('/')
    # then year would be parts[2]

